# ===== 新增：日志管理模块 =====
from PyQt5.QtWidgets import (QVBoxLayout, QMessageBox, QDialog,
                             QLineEdit, QDialogButtonBox, QFormLayout)
from yc import LogManager


class PlaylistDialog(QDialog):
    """创建歌单对话框"""

    def __init__(self, parent=None, existing_names=None, logger=None):
        super().__init__(parent)
        self.logger = logger or  LogManager()
        self.existing_names = existing_names or []
        self.setWindowTitle("创建歌单")
        self.setModal(True)
        self.resize(300, 100)
        layout = QVBoxLayout()
        # 输入框
        form_layout = QFormLayout()
        self.name_edit = QLineEdit()
        form_layout.addRow("歌单名称:", self.name_edit)
        layout.addLayout(form_layout)
        # 按钮
        button_box = QDialogButtonBox(QDialogButtonBox.Ok | QDialogButtonBox.Cancel)
        button_box.accepted.connect(self.accept)
        button_box.rejected.connect(self.reject)
        layout.addWidget(button_box)
        self.setLayout(layout)

    def accept(self):
        """确认创建歌单"""
        name = self.name_edit.text().strip()
        self.logger.debug(f"尝试创建歌单: {name}")
        # 验证歌单名称
        validation_result = self._validate_playlist_name(name)
        if validation_result is not True:
            self.logger.warning(f"歌单名称验证失败: {validation_result}")
            QMessageBox.warning(self, "警告", validation_result)
            return
        self.logger.debug(f"歌单名称验证通过: {name}")
        super().accept()

    def get_playlist_name(self):
        """获取歌单名称"""
        name = self.name_edit.text().strip()
        self.logger.debug(f"获取歌单名称: {name}")
        return name

    def _validate_playlist_name(self, name):
        """验证歌单名称"""
        if not name:
            return "请输入歌单名称"
        if name in self.existing_names:
            return f"歌单名称 '{name}' 已存在"
        return True

    def reject(self):
        """取消创建"""
        self.logger.debug("用户取消创建歌单")
        super().reject()